% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automl.R
\name{h2o.get_best_model}
\alias{h2o.get_best_model}
\title{Get best model of a given family/algorithm for a given criterion from an AutoML object.}
\usage{
h2o.get_best_model(
  object,
  algorithm = c("any", "basemodel", "deeplearning", "drf", "gbm", "glm",
    "stackedensemble", "xgboost"),
  criterion = c("AUTO", "AUC", "AUCPR", "logloss", "MAE", "mean_per_class_error",
    "deviance", "MSE", "predict_time_per_row_ms", "RMSE", "RMSLE", "training_time_ms")
)
}
\arguments{
\item{object}{H2OAutoML object}

\item{algorithm}{One of "any", "basemodel", "deeplearning", "drf", "gbm", "glm", "stackedensemble", "xgboost"}

\item{criterion}{Criterion can be one of the metrics reported in the leaderboard. If set to NULL, the same ordering
as in the leaderboard will be used.
Avaliable criteria:
\itemize{
\item{Regression metrics: deviance, RMSE, MSE, MAE, RMSLE}
\item{Binomial metrics: AUC, logloss, AUCPR, mean_per_class_error, RMSE, MSE}
\item{Multinomial metrics: mean_per_class_error, logloss, RMSE, MSE}
}
The following additional leaderboard information can be also used as a criterion:
\itemize{
\item{'training_time_ms': column providing the training time of each model in milliseconds (doesn't include the training of cross validation models).}
\item{'predict_time_per_row_ms': column providing the average prediction time by the model for a single row.}
}}
}
\value{
An H2OModel or NULL if no model of a given family is present
}
\description{
Get best model of a given family/algorithm for a given criterion from an AutoML object.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path, header = TRUE)
y <- "CAPSULE"
prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
aml <- h2o.automl(y = y, training_frame = prostate, max_runtime_secs = 30)
gbm <- h2o.get_best_model(aml, "gbm")
}
}
