% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.scoreHistory}
\alias{h2o.scoreHistory}
\title{Retrieve Model Score History}
\usage{
h2o.scoreHistory(object)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}
}
\description{
Retrieve Model Score History
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
cars["economy_20mpg"] <- as.factor(cars["economy_20mpg"])
predictors <- c("displacement","power","weight","acceleration","year")
response <- "economy_20mpg"
cars.split <- h2o.splitFrame(data = cars,ratios = 0.8, seed = 1234)
train <- cars.split[[1]]
valid <- cars.split[[2]]
cars_gbm <- h2o.gbm(x = predictors, y = response, 
                    training_frame = train, 
                    validation_frame = valid, 
                    seed = 1234)
h2o.scoreHistory(cars_gbm)
}
}
