% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{h2o.saveModelDetails}
\alias{h2o.saveModelDetails}
\title{Save an H2O Model Details}
\usage{
h2o.saveModelDetails(object, path = "", force = FALSE)
}
\arguments{
\item{object}{an \linkS4class{H2OModel} object.}

\item{path}{string indicating the directory the model details will be written to.}

\item{force}{logical, indicates how to deal with files that already exist.}
}
\description{
Save Model Details of an H2O Model in JSON Format
}
\details{
Model Details will download as a JSON file. In the case of existing files \code{force = TRUE}
will overwrite the file. Otherwise, the operation will fail.
}
\examples{
\dontrun{
# library(h2o)
# h2o.init()
# prostate.hex <- h2o.uploadFile(path = system.file("extdata", "prostate.csv", package="h2o"))
# prostate.glm <- h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"),
#                         training_frame = prostate.hex, family = "binomial", alpha = 0.5)
# h2o.saveModelDetails(object = prostate.glm, path = "/Users/UserName/Desktop", force=TRUE)
}
}
