% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.rmse}
\alias{h2o.rmse}
\title{Retrieves Root Mean Squared Error Value}
\usage{
h2o.rmse(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OModelMetrics} object of the correct type.}

\item{train}{Retrieve the training RMSE}

\item{valid}{Retrieve the validation RMSE}

\item{xval}{Retrieve the cross-validation RMSE}
}
\description{
Retrieves the root mean squared error value from an \linkS4class{H2OModelMetrics}
object.
If "train", "valid", and "xval" parameters are FALSE (default), then the training RMSEvalue is returned. If more
than one parameter is set to TRUE, then a named vector of RMSEs are returned, where the names are "train", "valid"
or "xval".
}
\details{
This function only supports \linkS4class{H2OBinomialMetrics},
\linkS4class{H2OMultinomialMetrics}, and \linkS4class{H2ORegressionMetrics} objects.
}
\examples{
\donttest{
library(h2o)
h2o.init()

prosPath <- system.file("extdata", "prostate.csv", package="h2o")
hex <- h2o.uploadFile(prosPath)

hex[,2] <- as.factor(hex[,2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = hex, distribution = "bernoulli")
perf <- h2o.performance(model, hex)
h2o.rmse(perf)
}
}
\seealso{
\code{\link{h2o.auc}} for AUC, \code{\link{h2o.mse}} for RMSE, and
         \code{\link{h2o.metric}} for the various threshold metrics. See
         \code{\link{h2o.performance}} for creating H2OModelMetrics objects.
}

