% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.mse}
\alias{h2o.mse}
\title{Retrieves Mean Squared Error Value}
\usage{
h2o.mse(object, valid = FALSE, ...)
}
\arguments{
\item{object}{An \linkS4class{H2OModelMetrics} object of the correct type.}

\item{valid}{Retreive the validation metric.}

\item{\dots}{Extra arguments to be passed if `object` is of type \linkS4class{H2OModel} (e.g. train=TRUE)}
}
\description{
Retrieves the mean squared error value from an \linkS4class{H2OModelMetrics}
object.
}
\details{
This function only supports \linkS4class{H2OBinomialMetrics},
\linkS4class{H2OMultinomialMetrics}, and \linkS4class{H2ORegressionMetrics} objects.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prosPath <- system.file("extdata", "prostate.csv", package="h2o")
hex <- h2o.uploadFile(prosPath)

hex[,2] <- as.factor(hex[,2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = hex, distribution = "bernoulli")
perf <- h2o.performance(model, hex)
h2o.mse(perf)
}
}
\seealso{
\code{\link{h2o.auc}} for AUC, \code{\link{h2o.mse}} for MSE, and
         \code{\link{h2o.metric}} for the various threshold metrics. See
         \code{\link{h2o.performance}} for creating H2OModelMetrics objects.
}

