% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.getModel}
\alias{h2o.getModel}
\title{Get an R reference to an H2O model}
\usage{
h2o.getModel(model_id, conn = h2o.getConnection(), linkToGC = FALSE)
}
\arguments{
\item{model_id}{A string indicating the unique model_id of the model to retrieve.}

\item{conn}{\linkS4class{H2OConnection} object containing the IP address and port
of the server running H2O.}

\item{linkToGC}{A logical value indicating whether to remove the underlying model
from the H2O cluster when the R proxy object is garbage collected.}
}
\value{
Returns an object that is a subclass of \linkS4class{H2OModel}.
}
\description{
Returns a reference to an existing model in the H2O instance.
}
\examples{
\dontrun{
library(h2o)
localH2O <- h2o.init()

iris.hex <- as.h2o(iris, localH2O, "iris.hex")
model_id <- h2o.gbm(x = 1:4, y = 5, training_frame = iris.hex)@model_id
model.retrieved <- h2o.getModel(model_id, localH2O)
}
}

