% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{numAvailableRecords}
\alias{numAvailableRecords}
\title{Probe the number of available records}
\usage{
numAvailableRecords(snpData)
}
\arguments{
\item{snpData}{a pathway to a file containing GWAS data. The data can be 
in a variety of forms, such as standard PLINK format (bed/bim/fam), 
PLINK2 format (pgen/pvar/psam), Oxford format (bgen/sample), or CSV 
format (csv format in much slower due to the lack of compression 
for non-binary files).}
}
\value{
Returns a vector of record counts. The vector is named by the containing file path.
}
\description{
\lifecycle{maturing} It can be useful to know the number of SNPs in
advance of running a set of analyses.
}
\examples{
dir <- system.file("extdata", package = "gwsem")
numAvailableRecords(file.path(dir,"example.bgen"))
}
