% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{buildOneFacRes}
\alias{buildOneFacRes}
\title{Build a model suitable for a single factor residual genome-wide association study}
\usage{
buildOneFacRes(
  phenoData,
  itemNames,
  factor = F,
  res = itemNames,
  covariates = NULL,
  ...,
  fitfun = c("WLS", "ML"),
  minMAF = 0.01,
  gxe = NULL,
  exogenous = NA,
  pred = "snp"
)
}
\arguments{
\item{phenoData}{a data.table containing the phenotypic data. Can
include more variables than those included in the analysis, but
GW-SEM will only use the items/covariates that are specified in
the model.}

\item{itemNames}{a character list of the names of the items that load 
onto the latent variable. These names must match variable names 
in the phenoData file.}

\item{factor}{A logical expression (\code{FALSE} or \code{TRUE}) indicating whether to estimate a regression pathway from the SNP to the latent factor (default FALSE).}

\item{res}{A character vector of phenotypic item names that indicate which specific items the user wishes to regress on the SNP. The default is to regress all of the items on the SNP.}

\item{covariates}{a character list of covariates that the latent variable 
will be regressed upon. The default vaule is NULL, but this is a 
silly value as typically analysts will include e.g. age, sex, and 
ancestry principle components in the analysis.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfun}{The fitfun argument specifies which fit function should 
be used in evaluating the GWAS model. Users may choose between 
the relatively rapid "WLS", or the slower but asymptotically 
optimal "ML". In many cases the the differences between the 
fit functions is trivial and the faster "WLS" option should be 
used, but in some situations the differences can be quite 
meaningful (such as when data are Missing at Random - MAR).}

\item{minMAF}{The minimum valid minor allele frequency (MAF). Large differences between the variances of two variables in the same model can cause optimization failures that invalidate the model. Further, very small minor allele frequencies are more affected by outliers or influential observations. Accordingly, users can specify the minimum allowable MAF. The default value is MAF > .01. This option only works when the SNP is entered into the model as an observed variable. If you wish to filter out small MAF alleles for all models, use other software programs such as PLINK.}

\item{gxe}{The observed variable name that will be used to moderate (interact with) 
the effect of the SNP on the phenotypes. For example, you may want to moderate 
the SNP regression by sex. In this situation, you would specify gxe = "sex" and 
add "snp_sex" to the list of covariates.}

\item{exogenous}{This argument specifies how you would like to integrate 
the covariates into the analysis. If exogenous = T, each items will 
be directly regressed on each covariate. If exogenous = F, the latent 
factor(s) will be directly regressed on each covariate. Setting 
exogenous = T does not assume that the items are related to the 
covariates proportional to their factor loadings (which is probably 
preferable in most cases).}

\item{pred}{character vector of variables that predict the phenotype(s). These predictors are always endogenous to the model (unaffected by the `exogenous` option).}
}
\value{
\code{buildOneFacRes} returns an \link[OpenMx:MxModel-class]{MxModel} object that can serve as input for the \link{GWAS} function.
}
\description{
\lifecycle{maturing}
The \code{buildOneFacRes} function is used to specify a single factor latent variable model where a combination of items as well as the latent variable may be predicted by a genomic variant such as a single nucleotide polymorphism, as well as range of covariates. \figure{resid.jpg}{Single Factor Model with a Focus on Residuals}
}
\details{
Be aware that a latent variable model is not identified if all of the residuals as well as the latent variable are simultaneously predicted by the SNP.  Specifically, if users wish to use the SNP to predict the latent variable, they much choose at least one (and preferably more that one) item to not be predicted by the SNP.

You can pass the result of this function to \link{GWAS} to run a GWAS.

Ordinal indicator thresholds are setup by
\link{setupThresholds}.
You can plot the model using \link[OpenMx]{omxGraphviz}.
}
\examples{
pheno <- list()
for (i in 1:5) pheno[[paste0('i',i)]] <- rnorm(500)
pheno <- as.data.frame(pheno)
buildOneFacRes(pheno, colnames(pheno))
}
\seealso{
Other model builder: 
\code{\link{buildItem}()},
\code{\link{buildOneFac}()},
\code{\link{buildTwoFac}()}
}
\concept{model builder}
