% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical.R
\name{elliptical}
\alias{elliptical}
\title{Elliptical Regression Models}
\usage{
elliptical(formula = formula(data), family = Normal,
  data = sys.parent(), dispersion = NULL, weights, subset,
  na.action = "na.fail", method = "elliptical.fit",
  control = glm.control(epsilon = 1e-04, maxit = 100, trace = F),
  model = F, x = F, y = T, contrasts = NULL, offset, ...)
}
\arguments{
\item{formula}{regression model formula as in \code{glm}.}

\item{family}{a description of the error distribution to be used in the model (see \code{elliptical.family} for details of family functions).}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{dispersion}{an optional fixed value for dispersion parameter.}

\item{weights}{an optional vector of weights to be used in the fitting process.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs (see \code{glm}).}

\item{method}{optimization method used to estimate the parameters. The default method "elliptical.fit" uses Fisher's scoring method. The alternative "model.frame" returns the model frame and does no fitting.}

\item{control}{a list of parameters for controlling the fitting process. For \code{egwr.fit} this is passed to \code{glm.control}.}

\item{model}{a logical value indicating whether model frame should be included as a component of the returned value.}

\item{x}{a logical value indicating whether the response vector used in the fitting process should be returned as components of the returned value.}

\item{y}{a logical value indicating whether model matrix used in the fitting process should be returned as components of the returned value.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of \code{model.matrix.default}.}

\item{offset}{this can be used to specify an a priori known component to be included in the linear predictor during fitting as in \code{glm}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
A list of class \dQuote{elliptical}:   
\item{coefficients}{coefficients of location of the model fit.}
\item{dispersion}{coefficients of dispersion of the model fit.}
\item{residuals}{the standardized residuals, that is the residuals in the final iteration of the optimization process.}
\item{fitted.values}{the fitted mean values.}
\item{loglik}{the likelihood logarithm value of the adjusted model's.}  
\item{Wg}{the values of the function W_g(u).}
\item{Wgder}{the values of the function W^'_g(u).}
\item{v}{the values of the function V(u).}
\item{rank}{the numeric rank of the fitted linear model.}
\item{inter}{the number of iterations of optimization process.}
\item{scale}{the values of the 4d_g for the specified distribution.}
\item{scaledispersion}{the values of the 4f_g for the specified distribution.}
\item{scalevariance}{the values of the scale variance for the specified distribution.}
\item{df}{the degrees of freedom for fitted model.}
\item{Xmodel}{is the model matrix.}
\item{weights}{the working weights, that is the weights in the final iteration of optimization process}
\item{df.residuals}{the residual degrees of freedom.}
\item{family}{the \code{family} object used.}
\item{formula}{the formula supplied.}
\item{terms}{the \code{terms} object used.}
\item{contrasts}{(where relevant) the contrasts used.}
\item{control}{the value of the\code{control} argument used.}
\item{call}{the matched call.}
\item{y}{the response variable used.}
}
\description{
The function implements linear elliptical regression models, specified by giving a symbolic description of the systematic and stochastic components.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5)
,data=luz)
elliptical.fitLII <- elliptical(y ~ x1+x2+x3, family = LogisII()
,data=luz)
}
\references{
Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\url{https://doi.org/10.1016/j.spl.2007.01.012}

Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{glm}}, \code{\link{family.elliptical}}, \code{\link{elliptical.diag}}
}
\keyword{elliptical}
\keyword{linear}
\keyword{models}
