% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variants.R
\name{get_variants_by_efo_trait}
\alias{get_variants_by_efo_trait}
\title{Get GWAS Catalog variants by EFO traits}
\usage{
get_variants_by_efo_trait(
  efo_trait = NULL,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{efo_trait}{A character vector of
\href{https://www.ebi.ac.uk/efo/}{EFO} trait descriptions, e.g.,
\code{'uric acid measurement'}.}

\item{verbose}{Whether the function should be
verbose about the different queries or not.}

\item{warnings}{Whether to print warnings.}

\item{page_size}{An \code{integer} scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A \linkS4class{variants} object.
}
\description{
Gets variants that match \href{https://www.ebi.ac.uk/efo/}{EFO} trait
description.
}
\keyword{internal}
