% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_merge.R
\name{tbl_merge}
\alias{tbl_merge}
\title{Merge tables}
\usage{
tbl_merge(tbls, tab_spanner = NULL)
}
\arguments{
\item{tbls}{(\code{list})\cr
List of gtsummary objects to merge}

\item{tab_spanner}{(\code{character})\cr
Character vector specifying the spanning headers.
Must be the same length as \code{tbls}. The
strings are interpreted with \code{gt::md}.
Must be same length as \code{tbls} argument. Default is \code{NULL}, and places
a default spanning header. If \code{FALSE}, no header will be placed.}
}
\value{
A \code{'tbl_merge'} object
}
\description{
Merge gtsummary tables, e.g. \code{tbl_regression}, \code{tbl_uvregression}, \code{tbl_stack},
\code{tbl_summary}, \code{tbl_svysummary}, etc.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed('survival')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
# Side-by-side Regression Models
library(survival)

t1 <-
  glm(response ~ trt + grade + age, trial, family = binomial) \%>\%
  tbl_regression(exponentiate = TRUE)
t2 <-
  coxph(Surv(ttdeath, death) ~ trt + grade + age, trial) \%>\%
  tbl_regression(exponentiate = TRUE)

tbl_merge(
  tbls = list(t1, t2),
  tab_spanner = c("**Tumor Response**", "**Time to Death**")
)

# Example 2 ----------------------------------
# Descriptive statistics alongside univariate regression, with no spanning header
t3 <-
  trial[c("age", "grade", "response")] \%>\%
  tbl_summary(missing = "no") \%>\%
  add_n() \%>\%
  modify_header(stat_0 ~ "**Summary Statistics**")
t4 <-
  tbl_uvregression(
    trial[c("ttdeath", "death", "age", "grade", "response")],
    method = coxph,
    y = Surv(ttdeath, death),
    exponentiate = TRUE,
    hide_n = TRUE
  )

tbl_merge(tbls = list(t3, t4)) \%>\%
  modify_spanning_header(everything() ~ NA_character_)
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
