% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_fmt_fun.R
\name{modify_fmt_fun}
\alias{modify_fmt_fun}
\title{Modify Formatting Functions}
\usage{
modify_fmt_fun(x, update, rows = NULL)
}
\arguments{
\item{x}{gtsummary object}

\item{update}{list of formulas or a single formula specifying the updated
formatting function.
The LHS specifies the column(s) to be updated,
and the RHS is the updated formatting function.}

\item{rows}{predicate expression to select rows in \code{x$table_body}.
Default is \code{NULL}. See details below.}
}
\description{
\lifecycle{maturing}
Use this function to update the way numeric columns and rows of \code{.$table_body}
are formatted
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{modify_fmt_fun_ex1.png}{options: width=45\%}}
}

\section{rows argument}{

The rows argument accepts a predicate expression that is used to specify
rows to apply formatting. The expression must evaluate to a logical when
evaluated in \code{x$table_body}. For example, to apply formatting to the age rows
pass \code{rows = variable == "age"}. A vector of row numbers is NOT acceptable.

A couple of things to note when using the \verb{rows=} argument.
\enumerate{
\item You can use saved objects to create the predicate argument, e.g.
\code{rows = variable == letters[1]}.
\item The saved object cannot share a name with a column in \code{x$table_body}.
The reason for this is that in \code{tbl_merge()} the columns are renamed,
and the renaming process cannot disambiguate the \code{variable} column from
an external object named \code{variable} in the following expression
\code{rows = .data$variable = .env$variable}.
}
}

\examples{
# Example 1 ----------------------------------
# show 'grade' p-values to 3 decimal places
modify_fmt_fun_ex1 <-
  lm(age ~ marker + grade, trial) \%>\%
  tbl_regression() \%>\%
  modify_fmt_fun(
    update = p.value ~ function(x) style_pvalue(x, digits = 3),
    rows = variable == "grade"
  )
}
\seealso{
Review \link[=syntax]{list, formula, and selector syntax} used throughout gtsummary

Other Advanced modifiers: 
\code{\link{modify_cols_merge}()},
\code{\link{modify_column_alignment}()},
\code{\link{modify_column_hide}()},
\code{\link{modify_table_body}()},
\code{\link{modify_table_styling}()}
}
\concept{Advanced modifiers}
