% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_q.R
\name{add_q.tbl_uvregression}
\alias{add_q.tbl_uvregression}
\title{Add a column of q-values to account for multiple comparisons}
\usage{
\method{add_q}{tbl_uvregression}(x, method = "fdr",
  pvalue_fun = x$inputs$pvalue_fun, ...)
}
\arguments{
\item{x}{\code{tbl_uvregression} object}

\item{method}{String indicating method to be used for p-value adjustment.
Methods from \link[stats:p.adjust]{stats::p.adjust} are accepted. Default is \code{method = 'fdr'}.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{...}{Additional arguments passed to or from other methods}
}
\value{
A \code{tbl_uvregression} object
}
\description{
Adjustments to are p-values are performed with \link[stats:p.adjust]{stats::p.adjust}.
}
\section{Example Output}{

\if{html}{\figure{tbl_uvr_q_ex.png}{options: width=50\%}}
}

\examples{
tbl_uvr_q_ex <-
  trial \%>\%
  dplyr::select(age, marker, grade, response) \%>\%
  tbl_uvregression(
    method = lm,
    y = age
  ) \%>\%
  add_global_p() \%>\%
  add_q()
}
\seealso{
Other tbl_uvregression tools: \code{\link{add_global_p.tbl_uvregression}},
  \code{\link{add_nevent.tbl_uvregression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_stack}},
  \code{\link{bold_p.tbl_uvregression}},
  \code{\link{inline_text.tbl_uvregression}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_uvregression}},
  \code{\link{tbl_merge}}, \code{\link{tbl_stack}},
  \code{\link{tbl_uvregression}}
}
\author{
Esther Drill, Daniel D. Sjoberg
}
\concept{tbl_uvregression tools}
