% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dstudy.R
\name{dstudy}
\alias{dstudy}
\alias{dstudy.components}
\alias{dstudy.dstudy}
\alias{dstudy.gstudy}
\title{Conduct a Univariate or Multivariate Decision (D) Study}
\usage{
dstudy(x, ...)

\method{dstudy}{components}(x, colname.objects, ...)

\method{dstudy}{gstudy}(x, colname.objects, data = NULL,
  colname.scores = NULL, colname.strata = NULL, weights = NULL, ...)

\method{dstudy}{dstudy}(x, colname.objects, weights = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{\link{gstudy}}, \code{dstudy}, or \code{components}}

\item{...}{ignored}

\item{colname.objects}{a string naming the source of variation for the object of measurement}

\item{data}{an optional data frame in long format with a column for item scores and columns for sources of variance}

\item{colname.scores}{an optional string that specifies the name of the column containing scores}

\item{colname.strata}{an optional string that specifies the name of the column containing strata (if conducting a multivariate G study)}

\item{weights}{an optional numeric vector containg one weight per stratum for composite scoring (if conducting a multivariate G study); defaults to equal weights}
}
\value{
an object of class "\code{dstudy}" that lists the variance components and corresponding measures of signal and noise (i.e., generalizability and dependability coefficients, universe score variance, relative and absolute error variance, and relative and absolute standard errors of measurement and estimation).
}
\description{
\code{dstudy} calculates generalizability and dependability coefficients from variance components.  It also provides standards errors of measurement and estimation.
}
\details{
A typical decision (D) study starts with updating variance components from the generalizaiblity (G) with the number of facet levels from the D-study data.  D-study data may or may not be the same data collected for the G study.  \code{dstudy} will update the variance components when you supply decision data and specify the name of the column identifying objects of measurement.  If you do not supply data or specify the score column, then \code{dstudy} will use the G-study variance components (i.e., with all n = 1) and return what is commonly known as intraclass correlation (i.e., the generalizability and dependability of a single observation).  If your D-study data are unbalanced (i.e., if the number of facet levels vary from one object of measurement to another), then \code{dstudy} will return an overall \code{components} object based on the median number of levels of the main facet effects and will store object-specific variance components as attributes (i.e., to facilitate scoring).
}
\section{Methods (by class)}{
\itemize{
\item \code{components}: D study of a \code{components} object

\item \code{gstudy}: D study of \code{\link{gstudy}} object

\item \code{dstudy}: D study of a \code{dstudy} object
}}
\examples{
#A univariate D study.
#Compare to results on page 116 of Brennan (2001).
data(Brennan.3.2)
formula.Brennan.3.2 <- "Score ~ (1 | Person) + (1 | Task) + (1 | Rater:Task) + 
  (1 | Person:Task)"
gstudy.out <- gstudy(data = Brennan.3.2, formula = formula.Brennan.3.2)
dstudy(gstudy.out, colname.objects = "Person", data = Brennan.3.2, colname.scores = "Score")

#A multivariate D study.
#Compare to results on pages 270-272 of Brennan (2001).
data(Rajaratnam.2)
formula.Rajaratnam.2 <- "Score ~ (1 | Person) + (1 | Item)"
gstudy.out <- gstudy(data = Rajaratnam.2, formula = formula.Rajaratnam.2, 
  colname.strata = "Subtest", colname.objects = "Person")
dstudy(gstudy.out, colname.objects = "Person", data = Rajaratnam.2, colname.scores = "Score", 
  colname.strata = "Subtest", weights = c(0.25, 0.5, 0.25))
}
\references{
Brennan, R. L. (2001). \emph{Generalizability theory}. New York: Springer.

Rajaratnam, N., Cronbach, L. J., & Gleser, G. C. (1965). Generalizability of stratified-parallel tests. \emph{Psychometrika}, \emph{30}(1), 39-56.
}

