% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrone.R
\name{gtfs_isochrone}
\alias{gtfs_isochrone}
\title{gtfs_isochrone}
\usage{
gtfs_isochrone(
  gtfs,
  from,
  start_time,
  end_time,
  day = NULL,
  from_is_id = FALSE,
  grep_fixed = TRUE,
  route_pattern = NULL,
  minimise_transfers = FALSE,
  hull_alpha = 0.1,
  quiet = FALSE
)
}
\arguments{
\item{gtfs}{A set of GTFS data returned from \link{extract_gtfs} or, for more
efficient queries, pre-processed with \link{gtfs_timetable}.}

\item{from}{Name, ID, or approximate (lon, lat) coordinates of start station
(as \code{stop_name} or \code{stop_id} entry in the \code{stops} table, or a vector of two
numeric values).}

\item{start_time}{Desired departure time at \code{from} station, either in seconds
after midnight, a vector of two or three integers (hours, minutes) or (hours,
minutes, seconds), an object of class \link{difftime}, \pkg{hms}, or
\pkg{lubridate}.}

\item{end_time}{End time to calculate isochrone}

\item{day}{Day of the week on which to calculate route, either as an
unambiguous string (so "tu" and "th" for Tuesday and Thursday), or a number
between 1 = Sunday and 7 = Saturday. If not given, the current day will be
used. (Not used if \code{gtfs} has already been prepared with
\link{gtfs_timetable}.)}

\item{from_is_id}{Set to \code{TRUE} to enable \code{from} parameter to specify entry
in \code{stop_id} rather than \code{stop_name} column of the \code{stops} table (same as
\code{from_to_are_ids} parameter of \link{gtfs_route}).}

\item{grep_fixed}{If \code{FALSE}, match station names (when passed as character
string) with \code{grep(..., fixed = FALSE)}, to allow use of \code{grep} expressions.
This is useful to refine matches in cases where desired stations may match
multiple entries.}

\item{route_pattern}{Using only those routes matching given pattern, for
example, "^U" for routes starting with "U" (as commonly used for underground
or subway routes. To negate the \code{route_pattern} -- that is, to include all
routes except those matching the pattern -- prepend the value with "!"; for
example "!^U" will include all services except those starting with "U". (This
parameter is not used at all if \code{gtfs} has already been prepared with
\link{gtfs_timetable}.)}

\item{minimise_transfers}{If \code{TRUE}, isochrones are calculated with
minimal-transfer connections to each end point, even if those connections are
slower than alternative connections with transfers.}

\item{hull_alpha}{alpha value of non-convex hulls returned as part of result
(see ?alphashape::ashape for details).}

\item{quiet}{Set to \code{TRUE} to suppress screen messages (currently just
regarding timetable construction).}
}
\value{
An object of class \code{gtfs_isochrone}, including \pkg{sf}-formatted
points representing the \code{from} station (\code{start_point}), the terminal end
stations (\code{end_points}), and all intermediate stations (\code{mid_points}) each
with the earliest possible arrival time, along with lines representing the
individual routes. A non-convex ("alpha") hull is also returned (as an
\pkg{sf} \code{POLYGON} object), including measures of area and "elongation",
which equals zero for a circle, and increases towards one for more elongated
shapes.
}
\description{
NOTE: This function has been deprecated. Please use \link{gtfs_traveltimes}
instead.
}
\details{
Calculate a single isochrone from a given start station, returning the list
of all stations reachable to the specified \code{end_time}.
}
\examples{
berlin_gtfs_to_zip ()
f <- file.path (tempdir (), "vbb.zip")
g <- extract_gtfs (f)
g <- gtfs_timetable (g)
from <- "Alexanderplatz"
start_time <- 12 * 3600 + 600
end_time <- start_time + 600
\dontrun{ # function is deprecated!
ic <- gtfs_isochrone (g,
                      from = from,
                      start_time = start_time,
                      end_time = end_time)
plot (ic)
}
}
