% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_horizontal_padding}
\alias{opt_horizontal_padding}
\title{Option to expand or contract horizontal padding}
\usage{
opt_horizontal_padding(data, scale = 1)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{scale}{A scale factor by which the horizontal padding will be adjusted.
Must be a number between \code{0} and \code{3}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Increase or decrease the horizontal padding throughout all locations of a
\strong{gt} table by use of a \code{scale} factor, which here is defined by a real
number between \code{0} and \code{3}. This function serves as a shortcut for setting
the following eight options in \code{\link[=tab_options]{tab_options()}}:
\itemize{
\item \code{heading.padding.horizontal}
\item \code{column_labels.padding.horizontal}
\item \code{data_row.padding.horizontal}
\item \code{row_group.padding.horizontal}
\item \code{summary_row.padding.horizontal}
\item \code{grand_summary_row.padding.horizontal}
\item \code{footnotes.padding.horizontal}
\item \code{source_notes.padding.horizontal}
}
}
\section{Figures}{

\if{html}{\figure{man_opt_horizontal_padding_1.png}{options: width=100\%}}
}

\section{Function ID}{

9-5
}

\examples{
# Use `exibble` to create a gt table with
# a number of table parts added; expand
# the horizontal padding across the entire
# table with `opt_horizontal_padding()`
tab_1 <-
  exibble \%>\%
  gt(rowname_col = "row", groupname_col = "group") \%>\%
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = list(
      min = ~min(., na.rm = TRUE),
      max = ~max(., na.rm = TRUE)
    )) \%>\%
  grand_summary_rows(
    columns = currency,
    fns = list(
      total = ~sum(., na.rm = TRUE)
    )) \%>\%
  tab_source_note(source_note = "This is a source note.") \%>\%
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) \%>\%
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) \%>\%
  opt_horizontal_padding(scale = 3)

}
\seealso{
Other Table Option Functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{Table Option Functions}
