% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{countrypops}
\alias{countrypops}
\title{Yearly populations of countries from 1960 to 2017}
\format{
A tibble with 12470 rows and 5 variables:
\describe{
\item{country_name}{Name of the country}
\item{country_code_2}{The 2-letter ISO 3166-1 country code}
\item{country_code_3}{The 3-letter ISO 3166-1 country code}
\item{year}{The year for the population estimate}
\item{population}{The population estimate, midway through the year}
}
}
\source{
\url{https://data.worldbank.org/indicator/SP.POP.TOTL}
}
\usage{
countrypops
}
\description{
A dataset that presents yearly, total populations of countries. Total
population is based on counts of all residents regardless of legal status or
citizenship. Country identifiers include the English-language country names,
and the 2- and 3-letter ISO 3166-1 country codes. Each row contains a
\code{population} value for a given \code{year} (from 1960 to 2017). Any \code{NA} values
for \code{populations} indicate the non-existence of the country during that year.
}
\section{Function ID}{

11-1
}

\examples{
# Here is a glimpse at the data
# available in `countrypops`
dplyr::glimpse(countrypops)

}
\seealso{
Other Datasets: 
\code{\link{exibble}},
\code{\link{gtcars}},
\code{\link{pizzaplace}},
\code{\link{sp500}},
\code{\link{sza}}
}
\concept{Datasets}
\keyword{datasets}
