% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_from_CT}
\alias{gsw_pt_from_CT}
\title{Potential temperature from Conservative Temperature}
\usage{
gsw_pt_from_CT(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
potential temperature [ degC ]
}
\description{
Potential temperature from Conservative Temperature
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
pt <- gsw_pt_from_CT(SA, CT)
stopifnot(all.equal(pt, c(28.783177048624573, 28.420955597191984, 22.784953468087107,
                          10.230534394434429, 6.829216587061605, 4.324534835990236)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_from_CT.html}
}
