% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SA_freezing_from_CT_poly}
\alias{gsw_SA_freezing_from_CT_poly}
\title{Compute Absolute Salinity at Freezing Point (Polynomial version)}
\usage{
gsw_SA_freezing_from_CT_poly(CT, p, saturation_fraction = 1)
}
\arguments{
\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
Absolute Salinity [ g/kg ]
}
\description{
Compute Absolute Salinity at Freezing Point (Polynomial version)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
CT <- c(-0.11901, -0.15608, -0.72138, -1.97738, -2.31728, -2.56764)
p <- c(       10,       50,      125,      250,      600,     1000)
saturation_fraction <- 1
SA <- gsw_SA_freezing_from_CT_poly(CT, p, saturation_fraction)
expect_equal(SA, c(2.281810267792954, 2.418134292641376, 11.971996354752958,
                 32.867931280363138, 34.015087798162732, 32.856434894818825))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SA_freezing_from_CT_poly.html}
}
