% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_BIC.R
\name{cp_BIC}
\alias{cp_BIC}
\title{Compute bayesian information criterion}
\usage{
cp_BIC(ll, n, k)
}
\arguments{
\item{ll}{numeric vector of length 1 (or an object of class 'logLik') storing the log-likelihood of the model of interest}

\item{n}{numeric vector of length 1 storing the sample size of data used to compute the log-likelihood}

\item{k}{numeric vector of length 1 storing the number of estimated parameters by the model}
}
\value{
numeric vector of length 1 storing the computed BIC.
}
\description{
Computes bayesian information criterion for comparing competing models.
}
\examples{
# Fit some model
lm_out <- lm(mpg ~ cyl + disp, data = mtcars)

# Compute BIC with your function
BIC_M <- cp_BIC(
    ll = logLik(lm_out),
    n = nobs(lm_out),
    k = length(coef(lm_out)) + 1 # intercept + reg coefs + error variance
)
}
\author{
Edoardo Costantini, 2023
}
