% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idst.R
\name{idst}
\alias{idst}
\title{Inverse Discrete Sine Transform}
\usage{
idst(x, n = NROW(x))
}
\arguments{
\item{x}{input discrete cosine transform, specified as a numeric vector or
matrix. In case of a vector it represents a single signal; in case of a
matrix each column is a signal.}

\item{n}{transform length, specified as a positive integer scalar. Default:
\code{NROW(x)}.}
}
\value{
Inverse discrete sine transform, returned as a vector or matrix.
}
\description{
Compute the inverse discrete sine transform of a signal.
}
\details{
The discrete sine transform (DST) is closely related to the discrete Fourier
transform. but using a purely real matrix. It is equivalent to the imaginary
parts of a DFT of roughly twice the length.
}
\examples{
x <- seq_len(100) + 50 * cos(seq_len(100) * 2 * pi / 40)
X <- dst(x)
xx <- idst(X)
all.equal(x, xx)

}
\seealso{
\code{\link{dst}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
