% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpslope.R
\name{grpSLOPE}
\alias{grpSLOPE}
\title{Group SLOPE (Group Sorted L-One Penalized Estimation)}
\usage{
grpSLOPE(X, y, group, fdr, lambda = "chiMean", sigma = NULL,
  n.MC = floor(length(unique(group))/2), MC.reps = 5000, verbose = FALSE,
  orthogonalize = NULL, normalize = TRUE, max.iter = 10000,
  dual.gap.tol = 1e-06, infeas.tol = 1e-06, x.init = vector(),
  prox = "rcpp")
}
\arguments{
\item{X}{The model matrix}

\item{y}{The response variable}

\item{group}{A vector describing the grouping structure. It should 
contain a group id for each predictor variable.}

\item{fdr}{Target false discovery rate}

\item{lambda}{Method used to obtain the regularizing sequence lambda. Possible
values are "BH", "gaussian", "gaussianMC", "chiOrthoMax", "chiOrthoMean",
"chiEqual", "chiMean", "chiMC". See \code{\link{lambdaGroupSLOPE}} for detail.
Alternatively, any non-increasing sequence of the correct length can be passed.}

\item{sigma}{Noise level. If ommited, estimated from the data. See details.}

\item{n.MC}{When \code{method} is "gaussianMC" or "chiMC", the corrections of the entries of lambda will be 
computed up to the index given by \code{n.MC} only. See Details.}

\item{MC.reps}{The number of repetitions of the Monte Carlo procedure}

\item{verbose}{Verbosity}

\item{orthogonalize}{Whether to orthogonalize the model matrix within each group.
Do not set manually unless you are certain that your data is appropriately pre-processed.}

\item{normalize}{Whether to center the input data and re-scale the columns
of the design matrix to have unit norm. Do not disable this unless you
are certain that your data is appropriately pre-processed.}

\item{max.iter}{See \code{\link{proximalGradientSolverGroupSLOPE}}.}

\item{dual.gap.tol}{See \code{\link{proximalGradientSolverGroupSLOPE}}.}

\item{infeas.tol}{See \code{\link{proximalGradientSolverGroupSLOPE}}.}

\item{x.init}{See \code{\link{proximalGradientSolverGroupSLOPE}}.}

\item{prox}{Same as argument \code{method} in \code{\link{proximalGradientSolverGroupSLOPE}}.}
}
\value{
A list with members:
  \describe{
    \item{beta}{Solution vector. See Details.}
    \item{c}{Solution vector of the transformed model. See Details.}
    \item{group.norms}{Overall effect of each group. See Details.}
    \item{selected}{Names of selected groups (i.e., groups of predictors with at least one coefficient estimate >0)}
    \item{optimal}{Convergence status}
    \item{iter}{Iterations of the proximal gradient method}
    \item{lambda}{Regularizing sequence}
    \item{lambda.method}{Method used to construct the regularizing sequence}
    \item{sigma}{(Estimated) noise level}
  }
}
\description{
Performs selection of significant groups of predictors and estimation of the
corresonding coefficients using the Group SLOPE method (see Brzyski et. al. (2015)
and Gossmann et. al. (2015)).
}
\details{
Multiple methods are available to generate the regularizing sequence \code{lambda},
see \code{\link{lambdaGroupSLOPE}} for detail.
If \code{method} is one of "chiOrthoMax", "chiOrthoMean",  "chiEqual", "chiMean", "chiMC",
then the model matrix is transformed by orthogonalization within each group (see Section 2.1
in Brzyski et. al.), and penalization is imposed on \eqn{\| X_{I_i} \beta_{I_i} \|}.
For other methods penalization is imposed directly on \eqn{\| \beta_{I_i} \|},
as in Gossmann et. al. (2015).
When \code{method} is "gaussianMC" or "chiMC", the corrections of the entries of lambda will be 
computed up to the index given by \code{n.MC} only. \code{n.MC} should be
less than or equal to \code{n.group}. Since lambda sequences obtained via MC tend to
flatten out quickly, it is reasonable to choose \code{n.MC} to be much smaller than the
number of groups. \cr
Due to within group orthogonalization (see Section 2.1 in Brzyski et. al. (2015)), the solution vector
\code{beta} cannot be  computed for methods "chiOrthoMax", "chiOrthoMean", "chiEqual", "chiMean",
"chiMC" if there are more predictors in a selected group than there are observations.
In that case only the solution vector \code{c} of the transformed (orthogonalized) model is returned.
Additionally, in any case the vector \code{group.norms} is returned with its \eqn{i}th entry
being \eqn{\| X_{I_i} \beta_{I_i} \|} or \eqn{\| \beta_{I_i} \|} (depending on method), i.e.,
the overall effect of each group. Also, note that the vector \code{beta} corresponds to the normalized
versions of \code{X} and \code{y}.
}
\examples{
# generate some data
set.seed(1)
A   <- matrix(rnorm(100^2), 100, 100)
grp <- rep(rep(1:20), each=5)
b   <- c(runif(20), rep(0, 80))
# (i.e., groups 1, 2, 3, 4, are truly significant)
y   <- A \%*\% b + rnorm(10) 
fdr <- 0.1 # target false discovery rate
# fit a Group SLOPE model
result <- grpSLOPE(X=A, y=y, group=grp, fdr=fdr)
result$selected
# [1] "1"  "2"  "3"  "4"  "14"
result$sigma
# [1] 0.7968632

}
\references{
D. Brzyski, W. Su, M. Bogdan (2015), \emph{Group SLOPE -- adaptive selection of groups of predictors}, \url{http://arxiv.org/abs/1511.09078}

A. Gossmann, S. Cao, Y.-P. Wang (2015), \emph{Identification of Significant Genetic Variants via SLOPE, and Its Extension to Group SLOPE}, \url{http://dx.doi.org/10.1145/2808719.2808743}
}

