% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PlotStates.R
\name{PlotStates}
\alias{PlotStates}
\title{Function to plot the hidden states}
\usage{
PlotStates(grove.obj, block = "Intercept", legend = FALSE, main = NULL,
  prior = FALSE)
}
\arguments{
\item{grove.obj}{Output from function \code{FAnova}.}

\item{block}{Which block to plot.}

\item{legend}{If \code{TRUE}, show legend.}

\item{main}{Main title.}

\item{prior}{If \code{TRUE}, plot prior state probabilities. If \code{FALE},
plot posterior state probabilities.}
}
\value{
A plot.
}
\description{
This function plots on a tree the state of each latent variables.
}
\examples{
\dontrun{
data <- GenerateSyntheticAnova(st.dev = 5, n.replicates = 5)
W <- DWT(data$noisy.Y)
X <- data$X
ans <- FAnova(W, X, ~ 1 + factorA + factorB)
PlotStates(ans)
PlotStates(ans, block = "factorA")
PlotStates(ans, block = "factorB")}
}

