% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_slr.R
\name{grouped_slr}
\alias{grouped_slr}
\alias{grouped_simplelm}
\title{Function to run simple linear regression (slr) on multiple variables across
multiple grouping variables.}
\usage{
grouped_slr(data, dep.vars, indep.vars, grouping.vars)
}
\arguments{
\item{data}{Dataframe from which variables are to be taken.}

\item{dep.vars}{List criterion or \strong{dependent} variables for simple linear
model (\code{y} in \code{y ~ x}).}

\item{indep.vars}{List predictor or \strong{independent} variables for simple
linear model (\code{x} in \code{y ~ x}).}

\item{grouping.vars}{List of grouping variables.}
}
\value{
A tibble dataframe with tidy results from simple linear regression
analyses. The estimates are standardized, i.e. the \code{lm} model used is
\code{scale(y) ~ scale(x)}, and not \code{y ~ x}.
}
\description{
Function to run simple linear regression (slr) on multiple variables across
multiple grouping variables.
}
\examples{

# in case of just one grouping variable
groupedstats::grouped_slr(data = iris,
dep.vars = c(Sepal.Length, Petal.Length),
indep.vars = c(Sepal.Width, Petal.Width),
grouping.vars = Species)

}
\author{
Indrajeet Patil
}
