% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_glm.R
\name{grouped_glm}
\alias{grouped_glm}
\title{Function to run generalized linear model on multiple variables across
multiple grouping variables.}
\usage{
grouped_glm(data, dep.vars, indep.vars, grouping.vars, family)
}
\arguments{
\item{data}{Dataframe from which variables are to be taken.}

\item{dep.vars}{List criterion or dependent variables for regression (\code{y} in
\code{y ~ x}).}

\item{indep.vars}{List predictor or independent variables for regression (\code{x}
in \code{y ~ x}).}

\item{grouping.vars}{List of grouping variables.}

\item{family}{A description of the error distribution and link function to be
used in the model. For glm this can be a character string naming a \code{family}
function, a \code{family} function or the result of a call to a family function.
For more, see \code{?stats::family}.}
}
\value{
A tibble dataframe with tidy results from linear regression analyses.
}
\description{
Function to run generalized linear model on multiple variables across
multiple grouping variables.
}
\examples{

groupedstats::grouped_glm(data = datasets::mtcars,
 dep.vars = am,
 indep.vars = wt,
 grouping.vars = cyl,
 family = "gaussian"
)
}
\author{
Indrajeet Patil
}
