% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrange.R
\name{rearrange}
\alias{rearrange}
\title{Arrange a data frame by a set of methods}
\usage{
rearrange(
  data,
  col = NULL,
  method = "pair_extremes",
  unequal_method = "middle",
  shuffle_members = FALSE,
  shuffle_pairs = FALSE,
  keep_factor = FALSE,
  factor_name = ".rearrange_factor"
)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}. When a \code{vector}, it is converted to a \code{data.frame}.}

\item{col}{Column to create sorting factor by. When \code{NULL} and \code{data} is a data frame,
it uses the row numbers.}

\item{method}{Sorting method.

One of: \code{"pair_extremes"}, \code{"center_max"}, or \code{"center_min"}.

\subsection{pair_extremes}{
The values are paired/grouped such that the highest and lowest values form the first group,
the second highest and the second lowest values form the second group, and so on.
The values are then sorted by these groups/pairs.

When \code{data} has an uneven number of rows,
the \code{unequal_method} argument determines which group should have only 1 element.

\strong{Example}:

The column values:

\code{c(1, 2, 3, 4, 5, 6)}

Creates the \strong{sorting factor}:

\code{c(1, 2, 3, 3, 2, 1)}

And are \strong{ordered as}:

\code{c(1, 6, 2, 5, 3, 4)}
}

\subsection{center_max}{
The highest value is positioned in the middle with
values decreasing around it.

\strong{Example}:

The column values:

\code{c(1, 2, 3, 4,} \strong{\code{5}}\code{)}

are \strong{ordered as}:

\code{c(1, 3,} \strong{\code{5}}\code{, 4, 2)}

}

\subsection{center_min}{
The lowest value is positioned in the middle with
values increasing around it.

\strong{Example}:

The column values:

\code{c(}\strong{\code{1}}\code{, 2, 3, 4, 5)}

are \strong{ordered as}:

\code{c(5, 3,} \strong{\code{1}}\code{, 2, 4)}

}}

\item{unequal_method}{Method for dealing with an unequal number of rows
in \code{data} when \code{method} is \code{"pair_extremes"}.

One of: \code{first}, \code{middle} or \code{last}

\subsection{first}{
The first group will have size \code{1}.

\strong{Example}:

The column values:

\code{c(1, 2, 3, 4, 5)}

Creates the \strong{sorting factor}:

\code{c(}\strong{\code{1}}\code{, 2, 3, 3, 2)}

And are \strong{ordered as}:

\code{c(}\strong{\code{1}}\code{, 2, 5, 3, 4)}

}

\subsection{middle}{
The middle group will have size \code{1}.

\strong{Example}:

The column values:

\code{c(1, 2, 3, 4, 5)}

Creates the \strong{sorting factor}:

\code{c(1, 3, }\strong{\code{2}}\code{, 3, 1)}

And are \strong{ordered as}:

\code{c(1, 5, } \strong{\code{3}}\code{, 2, 4)}

}
\subsection{last}{
The last group will have size \code{1}.

\strong{Example}:

The column values:

\code{c(1, 2, 3, 4, 5)}

Creates the \strong{sorting factor}:

\code{c(1, 2, 2, 1, }\strong{\code{3}}\code{)}

And are \strong{ordered as}:

\code{c(1, 4, 2, 3,} \strong{\code{5}}\code{)}

}}

\item{shuffle_members}{Whether to shuffle the pair members. (Logical)

For the \code{"center_*"} methods, this randomizes which values are
to the right and left of the center.}

\item{shuffle_pairs}{Whether to shuffle the pairs when
\code{method} is \code{"pair_extremes"}. (Logical)}

\item{keep_factor}{Whether to keep the sorting factor in the data frame. \code{Logical}.

This is mostly useful with the \code{"pair_extremes"} method.}

\item{factor_name}{Name of sorting factor.

N.B. Only used when \code{keep_factor} is \code{TRUE}.}
}
\value{
The sorted data frame. Optionally with the sorting factor added.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Creates a special sorting factor and sorts by it. Current methods are
\code{"pair_extremes"}, \code{"center_max"}, and \code{"center_min"}.

For an easier experience and usage examples, see the relevant wrapper functions: ...
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{rearrange functions}
\keyword{internal}
