% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdirichlet.R
\name{rdirichlet}
\alias{rdirichlet}
\title{Random Dirichlet}
\usage{
rdirichlet(n, alphas_list)
}
\arguments{
\item{n}{integer, the number of samples}

\item{alphas_list}{Named List of Integers: paramaters of the dirichlet,
interpreted as the number of success of each outcome}
}
\value{
n x length(alphas) named tibble representing the probability of observing each outcome
}
\description{
Randomly samples a vector of length n from a dirichlet distribution parameterized by a vector of alphas
PDF of Gamma with scale = 1 : f(x)= 1/(Gamma(a)) x^(a-1) e^-(x)
}
\examples{
rdirichlet(100, list(a = 20, b = 15, c = 60))

}
