% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaler.R
\name{implant}
\alias{implant}
\title{Implant the scale model in the location model}
\usage{
implant(location, scale, ...)
}
\arguments{
\item{location}{Model estimated using either \code{alm} or \code{adam}.}

\item{scale}{The scale model, estimate with \code{sm} method.}

\item{...}{Currently nothing. Implemented for flexibility.}
}
\value{
The model of the same class as the location model, but with scale
from the estimated model via \code{sm()}. This is needed to produce
appropriate forecasts in case of scale model and to take  into account
the correct number of estimated parameters.
}
\description{
The function implants the scale model into the location model. It currently works
with \link[greybox]{alm} / \link[smooth]{adam} and \code{sm()} method.
}
\details{
The function is needed in order to treat the scale of model correctly in the methods
like \code{forecast()}.
}
\examples{

xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+sqrt(exp(0.8+0.2*xreg[,1]))*rnorm(100,0,1),
              xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

# Estimate the location model
ourModel <- alm(y~.,xreg)
# Estimate the scale model
ourScale <- sm(ourModel,formula=~x1+x2)
# Implant scale into location
ourModel <- implant(ourModel, ourScale)

}
\seealso{
\link[greybox]{alm}, \link[smooth]{adam}, \link[greybox]{sm}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
