% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xregExpander.R
\name{xregExpander}
\alias{xregExpander}
\title{Exogenous variables expander}
\usage{
xregExpander(xreg, lags = c(-frequency(xreg):frequency(xreg)),
  silent = TRUE)
}
\arguments{
\item{xreg}{Vector / matrix / data.frame, containing variables that need
to be expanded. In case of vector / matrix it is recommended to provide
\code{ts} object, so the frequency of the data is taken into account.}

\item{lags}{Vector of lags / leads that we need to have. Negative values
mean lags, positive ones mean leads.}

\item{silent}{If \code{silent=FALSE}, then the progress is printed out.
Otherwise the function won't print anything in the console.}
}
\value{
\code{ts} matrix with the expanded variables is returned.
}
\description{
Function expands the provided matrix or vector of variables, producing
values with lags and leads specified by \code{lags} variable.
}
\details{
This function could be handy when you want to check if lags and leads
of a variable influence the dependent variable. Can be used together
with \code{xregDo="select"} in \link[smooth]{es}, \link[smooth]{ces},
\link[smooth]{ges} and \link[smooth]{ssarima}. All the missing values
in the beginning and at the end of lagged series are substituted by
mean forecasts produced using \link[smooth]{es}.
}
\examples{
# Create matrix of two variables, make it ts object and expand it
x <- cbind(rnorm(100,100,1),rnorm(100,50,3))
x <- ts(x,frequency=12)
xregExpander(x)

}
\seealso{
\code{\link[smooth]{es}, \link[greybox]{stepwise}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
