% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored.R
\name{pareto_censored}
\alias{pareto_censored}
\title{Pareto Censored Distribution}
\usage{
pareto_censored(
  scale,
  alpha,
  is_censored,
  censor = "right",
  lower = NULL,
  upper = NULL,
  dim = length(is_censored)
)
}
\arguments{
\item{scale}{Minimum value of the Pareto distribution.}

\item{alpha}{Shape parameter of the Pareto distribution.}

\item{is_censored}{Logical vector indicating whether each observation is censored.}

\item{censor}{Type of censoring: one of 'right', 'left', 'interval'.}

\item{lower}{Lower bound for interval censoring (optional).}

\item{upper}{Upper bound for interval censoring (optional).}

\item{dim}{Dimension of the data (optional, defaults to length of \code{scale}).}
}
\value{
A greta censored Pareto distribution node.
}
\description{
Creates a censored Pareto distribution for use with greta.
}
