% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BS_European_Greeks.R
\name{BS_European_Greeks}
\alias{BS_European_Greeks}
\title{Computes the greeks of an European call- or put-option in the Black Scholes
model.}
\usage{
BS_European_Greeks(
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  volatility = 0.3,
  dividend_yield = 0,
  payoff = "call",
  greek = c("fair_value", "delta", "vega", "theta", "rho", "epsilon", "lambda",
    "gamma", "vanna")
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset
}}

\item{exercise_price}{\itemize{
\item strike price of the option
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{payoff}{\itemize{
\item in c("call", "put")
}}

\item{greek}{\itemize{
\item greeks to be calculated in c("fair_value", "delta", "vega",
"theta", "rho", "epsilon", "lambda", "gamma", "vanna")
}}
}
\value{
Named vector containing the values of the greeks specified in the
parameter \code{greek}.
}
\description{
Computes the greeks of an European call- or put-option in the Black Scholes
model.
}
\examples{
BS_European_Greeks(initial_price = 120, exercise_price = 100,
r = 0.02, time_to_maturity = 4.5, dividend_yield = 0.015, volatility = 0.22,
greek = c("fair_value", "delta", "gamma"), payoff = "put")
}
