% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gran_advice.R
\name{gran_obs}
\alias{gran_obs}
\title{Cross tabulation of granularities
useful for validating if number of observations are sufficient to compute probability distributions}
\usage{
gran_obs(.data, gran1, gran2, hierarchy_tbl = NULL)
}
\arguments{
\item{.data}{A tsibble object.}

\item{gran1}{One of the temporal granularities to check for harmonies.}

\item{gran2}{The second temporal granularity in the pair.}

\item{hierarchy_tbl}{A hierarchy table specifying the hierarchy of units and their relationships for non-temporal case.}

\item{...}{Added arguments to be passed.}
}
\value{
A tibble with number of observations for each granularity.
}
\description{
Cross tabulation of granularities
useful for validating if number of observations are sufficient to compute probability distributions
}
\examples{
library(tsibbledata)
vic_elec \%>\% gran_obs("hour_day", "day_week")
}
