% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/youth_allowance.R
\name{youth_allowance}
\alias{youth_allowance}
\title{Youth allowance}
\usage{
youth_allowance(
  fortnightly_income = 0,
  annual_income = 0,
  fy.year = NULL,
  include_ES = TRUE,
  age = 18L,
  eligible_if_over22 = FALSE,
  has_partner = FALSE,
  lives_at_home = FALSE,
  n_dependants = 0L,
  isjspceoalfofcoahodeoc = FALSE,
  is_student = TRUE,
  per = c("fortnight", "year"),
  max_rate = NULL,
  es = NULL,
  taper1 = NULL,
  taper2 = NULL,
  FT_YA_student_lower = NULL,
  FT_YA_student_upper = NULL,
  FT_YA_jobseeker_lower = NULL,
  FT_YA_jobseeker_upper = NULL,
  partner_fortnightly_income = 0,
  partner_is_pensioner = FALSE,
  partner_taper = 0.6
)
}
\arguments{
\item{fortnightly_income, annual_income}{Individual's income. Default is zero. 
You may provided both; providing both when the ratio is not 26 is an error.}

\item{fy.year}{Financial year. Default is current financial year.}

\item{include_ES}{(logical, default: \code{TRUE}) If \code{FALSE} do not
include the energy supplement.}

\item{age}{The individual's age. Default is 18 years. If type double will be
coerced to integer via truncation (i.e. 17.9 becomes 17).}

\item{eligible_if_over22}{To be eligible for Youth Allowance while over 22, 
recipients must either commence full-time study or an Australian 
apprenticeship having been in receipt of an income support payment for at 
least 6 out of the last 9 months since turning 22, or study an approved 
course in English where English is not their first language.}

\item{has_partner}{Does the individual have a partner?}

\item{lives_at_home}{Does the individual live at home with their parents?}

\item{n_dependants}{How many dependant children does the individual have?}

\item{isjspceoalfofcoahodeoc}{Is the recipient a single job seeker principal
carer, either of large family or foster child/ren, or who is a home or 
distance educator of child/ren?}

\item{is_student}{Is the individual a student? Note that apprentices are 
considered students.}

\item{per}{How often the payment will be made. Default is fortnightly. At 
present payments can only be fortnightly.}

\item{max_rate}{If not \code{NULL}, a length-1 double representing the 
maximum \emph{fortnightly} rate for youth allowance.}

\item{es}{If not \code{NULL}, a length-1 double as the energy supplement.}

\item{taper1}{The amount at which the payment is reduced for each dollar 
earned between the lower and upper bounds.}

\item{taper2}{The amount at which the payment is reduced for each dollar
earned above the upper bound.}

\item{FT_YA_student_lower}{Student and apprentice lower bound for which 
reduction in payment occurs at rate \code{taper1}.}

\item{FT_YA_student_upper}{Student and apprentice upper bound for which 
reduction in payment occurs at rate \code{taper1}. Student and apprentice
 lower bound for which reduction in payment occurs at rate taper2.}

\item{FT_YA_jobseeker_lower}{Jobseeker lower bound for which reduction in
payment occurs at rate taper1}

\item{FT_YA_jobseeker_upper}{Jobseeker upper bound for which reduction in 
payment occurs at rate taper1. Student and apprentice lower bound for which 
reduction in payment occurs at rate \code{taper2}.}

\item{partner_fortnightly_income}{The partner's fortnightly income (or zero 
if no partner).}

\item{partner_is_pensioner}{(logical, default: \code{FALSE}) Is the 
individual's partner in receipt of a \emph{pension} (or benefit)?}

\item{partner_taper}{The amount by which the payment is reduced for each 
dollar earned by the individual's partner. (See \url{https://guides.dss.gov.au/guide-social-security-law/4/2/8/40}.)}
}
\description{
Youth allowance
}
