% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmixmorm.R
\name{rmixnorm}
\alias{rmixnorm}
\title{Generate random variables from mixture normal distribution.}
\usage{
rmixnorm(n, means, sigmas, weights)
}
\arguments{
\item{n}{"integer", numbers of samples to be generated.}

\item{means}{"q-by-k matrix" mean value within each component, total k components.}

\item{sigmas}{"q-by-q-by-k" variance covariance matrix with in each component.}

\item{weights}{"k-length vector" weights in each component.}
}
\value{
"matrix".
}
\description{
Random variables from mixture of normals.
}
\examples{
n <- 1000
means <- matrix(c(-5, 0, 5), 1)
sigmas <- array(c(1, 1, 1), c(1, 1, 3))
weights <- c(0.3, 0.4, 0.3)
out <- rmixnorm(n, means, sigmas, weights)
hist(out, breaks = 100, freq = FALSE)
}
\references{
Villani et al 2009.
}
\author{
Feng Li, Central University of Finance and Economics.
}
