% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-coefs.R
\name{smooth_coefs}
\alias{smooth_coefs}
\alias{smooth_coefs.gam}
\alias{smooth_coefs.bam}
\alias{smooth_coefs.gamm}
\alias{smooth_coefs.gamm4}
\alias{smooth_coefs.list}
\alias{smooth_coefs.mgcv.smooth}
\alias{smooth_coefs.scam}
\title{Coefficients for a particular smooth}
\usage{
smooth_coefs(object, ...)

\method{smooth_coefs}{gam}(object, select, term = deprecated(), ...)

\method{smooth_coefs}{bam}(object, select, term = deprecated(), ...)

\method{smooth_coefs}{gamm}(object, select, term = deprecated(), ...)

\method{smooth_coefs}{gamm4}(object, select, term = deprecated(), ...)

\method{smooth_coefs}{list}(object, select, term = deprecated(), ...)

\method{smooth_coefs}{mgcv.smooth}(object, model, ...)

\method{smooth_coefs}{scam}(object, select, term = deprecated(), ...)
}
\arguments{
\item{object}{a fitted GAM(M) object, or, for the \code{"mgcv.smooth"} method,
an object that inherits from class \code{mgcv.smooth}.}

\item{...}{arguments passed to other methods.}

\item{select}{character; the label of the smooth whose coefficients will be
returned.}

\item{term}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{select} instead.}

\item{model}{a fitted GAM(M) object.}
}
\value{
A numeric vector of model coefficients.
}
\description{
Returns a vector of model coefficients of the parametric terms that represent
the supplied smooth.
}
\examples{
\dontshow{
op <- options(pillar.sigfig = 3, cli.unicode = FALSE)
}
load_mgcv()
df <- data_sim("eg1", seed = 2)
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

## IGNORE_RDIFF_BEGIN
smooth_coefs(m, select = "s(x2)")
## IGNORE_RDIFF_END
\dontshow{
options(op)
}
}
\seealso{
\code{\link[=smooth_coef_indices]{smooth_coef_indices()}} for extracting the indices of the
coefficients for a particular smooth.
}
\author{
Gavin L. Simpson
}
