% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{mh_draws}
\alias{mh_draws}
\alias{mh_draws.gam}
\title{Posterior samples using a Gaussian approximation to the posterior
distribution}
\usage{
mh_draws(model, ...)

\method{mh_draws}{gam}(
  model,
  n,
  burnin = 1000,
  thin = 1,
  t_df = 40,
  rw_scale = 0.25,
  index = NULL,
  ...
)
}
\arguments{
\item{model}{a fitted R model. Currently only models fitted by \code{mgcv::gam()}
or \code{mgcv::bam()}, or return an object that \emph{inherits} from such objects are
supported. Here, "inherits" is used in a loose fashion; models fitted by
\code{scam::scam()} are support even though those models don't strictly inherit
from class \code{"gam"} as far as \code{inherits()} is concerned.}

\item{...}{arguments passed to methods.}

\item{n}{numeric; the number of posterior draws to take.}

\item{burnin}{numeric; the length of any initial burn in period to discard.
See \code{mgcv::gam.mh()}.}

\item{thin}{numeric; retain only \code{thin} samples. See \code{mgcv::gam.mh()}.}

\item{t_df}{numeric; degrees of freedom for static multivariate \emph{t} proposal.
See \code{mgcv::gam.mh()}.}

\item{rw_scale}{numeric; factor by which to scale posterior covariance
matrix when generating random walk proposals. See \code{mgcv::gam.mh()}.}

\item{index}{numeric; vector of indices of coefficients to use. Can be used
to subset the mean vector and covariance matrix extracted from \code{model}.}
}
\description{
Posterior samples using a Gaussian approximation to the posterior
distribution
}
