% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoweek.R
\name{isoweek}
\alias{isoweek}
\title{Constructor for isoweek objects}
\usage{
isoweek(year = integer(), week = integer())
}
\arguments{
\item{year}{\verb{[integer]}

Vector representing the year associated with \code{week}.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{week}{\verb{[integer]}

Vector representing the week associated with `year.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}
}
\value{
A \verb{<grates_isoweek>} object.
}
\description{
\code{isoweek()} is a constructor for \verb{<grates_isoweek>} objects.
}
\details{
isoweeks are defined to start on a Monday and \verb{<grates_isoweek>} objects are
stored as the number of weeks (starting at 0) from the first Monday prior to
the Unix Epoch (1970-01-01). That is, the number of seven day periods from
1969-12-29.

Internally they have the same representation as a \verb{<grates_yearweek_monday>}
object so are akin to an alias but with a marginally more efficient
implementation.
}
\examples{
isoweek(year = 2000L, week = 3L)

}
\seealso{
\code{as_isoweek()} and \code{new_isoweek()}.
}
