% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.LG.R
\name{est.LG}
\alias{est.LG}
\title{Estimate graphons based on empirical degrees}
\usage{
est.LG(A, K)
}
\arguments{
\item{A}{an \eqn{(n-by-n)} binary adjacency matrix.}

\item{K}{the number of blocks provided by an user.}
}
\value{
a named list containing
\describe{
\item{H}{a \eqn{(K-by-K)} matrix of 3D histogram.}
\item{P}{an \eqn{(n-by-n)} corresponding probability matrix.}
\item{B}{a length-\eqn{K} list where each element is a vector of nodes/indices
for each cluster.}
}
}
\description{
\code{est.LG} takes a 2-stage approach. First it adopts largest gap criterion on empirical degrees to
estimate blocks of a given network under Stochastic Blockmodel framework.
Then a consistent histogram estimator is utilized to estimate graphons based on
estimated blocks in a given network.
}
\examples{
## generate a graphon of type No.10 with 3 clusters
W = gmodel.preset(3,id=10)

## create a probability matrix for 100 nodes
graphW = gmodel.block(W,n=100)
P = graphW$P

## draw 23 observations from a given probability matrix
A = gmodel.P(P,rep=23)

## run LG algorithm with a rough guess for K=2,3,4
res2 = est.LG(A,K=2)
res3 = est.LG(A,K=3)
res4 = est.LG(A,K=4)

## compare true probability matrix and estimated ones
par(mfrow=c(1,4))
image(P); title("main")
image(res2$P); title("LG with K=2")
image(res3$P); title("LG with K=3")
image(res4$P); title("LG with K=4")


}
\references{
Channarond, A., Daudin, J., and Robin, S. (2012) \emph{Classification
and estimation in the SBM based on empirical degrees}. Electronic Journal
of Statistics, Vol.6:2574-2601.

Chan, S.H. and Airoldi, E.M. (2014) \emph{A consistent histogram
estimator for exchangeable graph models}. Journal of Machine Learning Research Workshop
and Conference Proceedings, Vol.32, No.1:208-216.
}
\seealso{
\code{\link{est.SBA}}
}
