% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graphab_metric.R
\name{get_graphab_metric}
\alias{get_graphab_metric}
\title{Get metrics computed at the node in the Graphab project}
\usage{
get_graphab_metric(proj_name, proj_path = NULL)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}
}
\value{
A data.frame with metrics computed at the patch level.
}
\description{
The function gets the metrics computed at the node-level in
the Graphab project
}
\details{
The imported metrics describe the patches and have been computed
from the different graphs created in the Graphab project.
See more information in Graphab 2.8 manual:
\url{https://sourcesup.renater.fr/www/graphab/download/manual-2.8-en.pdf}
}
\examples{
\dontrun{
get_graphab_metric(proj_name = "grphb_ex")
}
}
\author{
P. Savary
}
