% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatterbar_sd_sc.R
\name{plot_scatterbar_sd_sc}
\alias{plot_scatterbar_sd_sc}
\title{Plot scatter dots on a bar graph with SD error bars with two variables.}
\usage{
plot_scatterbar_sd_sc(
  data,
  xcol,
  ycol,
  colour = "ok_orange",
  symsize = 2.5,
  symthick = 1,
  bwid = 0.7,
  ewid = 0.3,
  jitter = 0,
  b_alpha = 1,
  s_alpha = 1,
  TextXAngle = 0,
  fontsize = 20
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{colour}{colour of boxes and dots; a number between 1-64, any hexcode or names from \code{grafify} colour palettes. Default is \code{ok_orange}.}

\item{symsize}{size of point symbols, default set to 2.}

\item{symthick}{thickness of symbol border, default set to 1.}

\item{bwid}{width of bars, default set to 0.7}

\item{ewid}{width of error bars, default set to 0.3.}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0 (i.e. aligned symbols). To reduce symbol overlap, try 0.1-0.3 or higher.}

\item{b_alpha}{fractional opacity of bars, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function is related to \code{plot_scatterbar_sd}, but this one maps a single or same colour, therefore \verb{_sc}.
The only new argument is \code{colour}, which can be any hexcode or name of colours in the \code{all_grafify} \href{https://grafify-vignettes.netlify.app/colour_palettes.html#full-list-of-hexcodes}{palette}.
The default colour is \code{ok_orange}. \code{ColPal} and \code{ColRev} arguments are not available. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\examples{

plot_scatterbar_sd_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time)
plot_scatterbar_sd_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time, 
colour = "ok_grey")
}
