% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpuVector.R
\docType{methods}
\name{gpuVector}
\alias{gpuVector}
\alias{gpuVector,vector,missing-method}
\alias{gpuVector,vector}
\alias{gpuVector,missingOrNULL,ANY-method}
\alias{gpuVector,missingOrNULL}
\alias{gpuVector,numeric,numericOrInt-method}
\alias{gpuVector,vector}
\title{Construct a gpuVector}
\usage{
gpuVector(data, length, type = NULL, ...)

\S4method{gpuVector}{vector,missing}(data, type = NULL, ctx_id = NULL)

\S4method{gpuVector}{missingOrNULL,ANY}(data, length, type = NULL,
  ctx_id = NULL)

\S4method{gpuVector}{numeric,numericOrInt}(data, length, type = NULL,
  ctx_id = NULL)
}
\arguments{
\item{data}{An object that is or can be converted to a 
\code{vector}}

\item{length}{A non-negative integer specifying the desired length.}

\item{type}{A character string specifying the type of gpuVector.  Default
is NULL where type is inherited from the source data type.}

\item{...}{Additional method to pass to gpuVector methods}

\item{ctx_id}{An integer specifying the object's context}
}
\value{
A gpuVector object
}
\description{
Construct a gpuVector of a class that inherits
from \code{gpuVector}
}
\author{
Charles Determan Jr.
}
