% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-table.R
\name{gpkg_table_pragma}
\alias{gpkg_table_pragma}
\alias{gpkg_table_pragma.character}
\alias{gpkg_table_pragma.SQLiteConnection}
\alias{gpkg_table_pragma.geopackage}
\alias{gpkg_table}
\alias{gpkg_table.default}
\alias{gpkg_collect}
\alias{gpkg_tbl}
\alias{gpkg_rast}
\alias{gpkg_vect}
\title{Lazy Access to Tables by Name}
\usage{
gpkg_table_pragma(x, table_name = NULL, ...)

\method{gpkg_table_pragma}{character}(x, table_name = NULL, ...)

\method{gpkg_table_pragma}{SQLiteConnection}(x, table_name, ...)

\method{gpkg_table_pragma}{geopackage}(x, table_name = NULL, ...)

gpkg_table(x, table_name, collect = FALSE, query_string = FALSE, ...)

\method{gpkg_table}{default}(x, table_name, collect = FALSE, query_string = FALSE, ...)

gpkg_collect(x, table_name, query_string = FALSE, ...)

gpkg_tbl(x, table_name, ...)

gpkg_rast(x, table_name = NULL, ...)

gpkg_vect(x, table_name, ...)
}
\arguments{
\item{x}{A \emph{geopackage} object or character path to GeoPackage file}

\item{table_name}{\emph{character}. One or more table names; for \code{gpkg_table_pragma()} if \code{table_name=NULL} returns a record for each table. \code{gpkg_table()} requires \code{table_name} be specified}

\item{...}{Additional arguments. In \code{gpkg_table()} arguments in \code{...} are passed to \code{dplyr::tbl()}. For \code{gpkg_table_pragma()}, \code{...} arguments are (currently) not used. For \code{gpkg_rast()} additional arguments are passed to \code{terra::rast()}. For \code{gpkg_vect()} additional arguments (such as \code{proxy=TRUE}) are passed to \code{terra::vect()}.}

\item{collect}{\emph{logical}. Materialize a data.frame object in memory? Default: \code{FALSE} requires 'dbplyr' package. \code{TRUE} uses 'RSQLite'.}

\item{query_string}{\emph{logical}. Return SQLite query rather than executing it? Default: \code{FALSE}}
}
\value{
\code{gpkg_table()}: A 'dbplyr' object of class \emph{tbl_SQLiteConnection}

\code{gpkg_collect()}: An object of class \emph{data.frame}

\code{gpkg_tbl()}: An object of class \emph{tbl_SQLiteConnection}

\code{gpkg_rast()}: A 'terra' object of class \emph{SpatRaster}

\code{gpkg_vect()}: A 'terra' object of class \emph{SpatVector} (may not contain geometry columns)
}
\description{
\code{gpkg_table_pragma()}: Get information on a table in a GeoPackage (without returning the whole table).

\code{gpkg_table()}: access a specific table (by name) and get a "lazy" \code{tibble} object referencing that table

\code{gpkg_collect()}: alias for \code{gpkg_table(..., collect=TRUE)}

\code{gpkg_tbl()}: shorthand for \code{gpkg_table(..., collect=FALSE)}(default) that always returns a 'dplyr' object.
}
\examples{
\dontshow{if (!inherits(try(requireNamespace("RSQLite", quietly = TRUE)), 'try-error') &&!inherits(try(requireNamespace("dbplyr", quietly = TRUE)), 'try-error') && !inherits(try(requireNamespace("terra", quietly = TRUE)), 'try-error')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}

tf <- tempfile(fileext = ".gpkg")

r <- terra::rast(system.file("extdata", "dem.tif", package = "gpkg"))

gpkg_write(r,
           destfile = tf,
           RASTER_TABLE = "DEM1",
           FIELD_NAME = "Elevation")

gpkg_write(r,
           destfile = tf,
           append = TRUE,
           RASTER_TABLE = "DEM2",
           FIELD_NAME = "Elevation")

g <- geopackage(tf)

# inspect gpkg_contents table
gpkg_table(g, "gpkg_contents")

gpkg_vect(g, "gpkg_contents")

# materialize a data.frame from gpkg_2d_gridded_tile_ancillary
library(dplyr, warn.conflicts = FALSE)

gpkg_table(g, "gpkg_2d_gridded_tile_ancillary") \%>\% 
  dplyr::filter(tpudt_name == "DEM2") \%>\% 
  dplyr::select(mean, std_dev) \%>\% 
  dplyr::collect()

gpkg_disconnect(g)
}
