% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeinfo.R
\name{plot.pltree}
\alias{plot.pltree}
\alias{plot.PlackettLuce}
\alias{node_labels}
\alias{node_rules}
\alias{top_items}
\title{Get node labels and rules used in a party tree}
\usage{
\method{plot}{pltree}(x, log = TRUE, ref = NULL, ...)

\method{plot}{PlackettLuce}(x, ...)

node_labels(x)

node_rules(x)

top_items(x, top = 5)
}
\arguments{
\item{x}{an object of class \code{party} or \code{PlackettLuce}}

\item{log}{logical, if \code{TRUE} log-worth coefficients are 
displayed instead of worth}

\item{ref}{optional, character or integer for the reference item when
\var{log} = \code{TRUE}}

\item{...}{additional arguments passed to methods. See details}

\item{top}{an integer for the number of items to return}
}
\value{
a vector with the node labels, 
 a data.frame with node rules, a ggplot object
}
\description{
Returns the covariates used to split a recursive
 partitioning tree and the rules that were applied 
 to build the tree
}
\details{
multcomp = TRUE adds multi-comparison letters from multcompView
ci.level = numeric for the confidence interval levels
}
\examples{
\donttest{
library("PlackettLuce")
library("ggplot2")

data("beans", package = "PlackettLuce")

G = rank_tricot(data = beans,
                items = c(1:3),
                input = c(4:5),
                group = TRUE,
                additional.rank = beans[c(6:8)])
  
pld = cbind(G, beans[,c("maxTN", "season", "lon")])

tree = pltree(G ~ maxTN + season + lon, data = pld)

node_labels(tree)

node_rules(tree)

top_items(tree)

plot(tree)

plot(tree, log = FALSE)

#################################

# Plot PlackettLuce 
R = matrix(c(1, 2, 4, 3,
             4, 1, 2, 3,
             2, 4, 1, 3,
             1, 2, 3, 0,
             2, 1, 4, 3,
             1, 4, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) = c("apple", "banana", "orange", "pear")
R = as.rankings(R)

mod = PlackettLuce(R)

plot(mod)

}

}
\author{
Kauê de Sousa
}
