% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendallTau.R
\name{kendallTau}
\alias{kendallTau}
\alias{kendallTau.default}
\alias{kendallTau.matrix}
\alias{kendallTau.rankings}
\alias{kendallTau.grouped_rankings}
\alias{kendallTau.paircomp}
\title{Kendall rank correlation coefficient}
\usage{
kendallTau(x, y, null.rm = TRUE, average = TRUE, na.omit = FALSE, ...)

\method{kendallTau}{default}(x, y, null.rm = TRUE, ...)

\method{kendallTau}{matrix}(x, y, null.rm = TRUE, average = TRUE, na.omit = FALSE, ...)

\method{kendallTau}{rankings}(x, y, ...)

\method{kendallTau}{grouped_rankings}(x, y, ...)

\method{kendallTau}{paircomp}(x, y, ...)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame}

\item{y}{a vector, matrix or data frame with compatible dimensions to \code{x}}

\item{null.rm}{logical, to remove zeros from \code{x} and \code{y}}

\item{average}{logical, if \code{FALSE} returns the kendall and N-effective for each entry}

\item{na.omit}{logical, if \code{TRUE} ignores entries with kendall = NA when computing the average}

\item{...}{further arguments affecting the Kendall tau produced. See details}
}
\value{
The Kendall correlation coefficient and the Effective N, which 
is the equivalent N needed if all items were compared to all items. 
Can be used for significance testing.
}
\description{
Compute Kendall rank correlation coefficient between two objects. 
Kendall is a coefficient used in statistics to measure the ordinal 
association between two measured quantities. A tau test is a non-parametric 
hypothesis test for statistical dependence based on the tau coefficient.
The 'kendallTau' function applies the "kendall" method from 'stats::cor' 
with some previous treatment in the data, such as converting floating numbers
into ranks (from the higher being the first and negative being the last) 
and the possibility to remove zeros from incomplete ranks
}
\examples{

# Vector based example same as stats::cor(x, y, method = "kendall")
# but showing N-effective
x = c(1, 2, 3, 4, 5)

y = c(1, 1, 3, 2, NA)

w = c(1, 1, 3, 2, 5)

kendallTau(x, y)

kendallTau(x, w)

# Matrix and PlacketLuce ranking example 

library("PlackettLuce")
 
R = matrix(c(1, 2, 4, 3,
             1, 4, 2, 3,
             1, 2, NA, 3,
             1, 2, 4, 3,
             1, 3, 4, 2,
             1, 4, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) = LETTERS[1:4]

G = group(as.rankings(R), 1:6)

mod = pltree(G ~ 1, data = G)

preds = predict(mod)

kendallTau(R, preds)

# Also returns raw values (no average) 

kendallTau(R, preds, average = FALSE)

# Choose to ignore entries with NA
R2 = matrix(c(1, 2, 4, 3,
              1, 4, 2, 3,
              NA, NA, NA, NA,
              1, 2, 4, 3,
              1, 3, 4, 2,
              1, 4, 3, 2), nrow = 6, byrow = TRUE)

kendallTau(R, R2, average = FALSE)

kendallTau(R, R2, average = TRUE)

kendallTau(R, R2, average = TRUE, na.omit = TRUE)

}
\references{
Kendall M. G. (1938). Biometrika, 30(1–2), 81–93. 
\doi{https://doi.org/10.1093/biomet/30.1-2.81}
}
\seealso{
\code{\link[stats]{cor}}

Other goodness-of-fit functions: 
\code{\link{kendallW}()},
\code{\link{pseudoR2}()}
}
\author{
Kauê de Sousa and Jacob van Etten
}
\concept{goodness-of-fit functions}
