% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_paircomp.R
\name{rank_paircomp}
\alias{rank_paircomp}
\title{Pairwise comparison rankings}
\usage{
rank_paircomp(object)
}
\arguments{
\item{object}{an object of class "rankings" or "grouped_rankings" 
which is a matrix of dense rankings.}
}
\value{
an object of class "paircomp" which is a matrix 
 of pairwise comparisons
}
\description{
Pairwise comparisons from a ranking object. Ties are not 
taken into account, then they are added as NA's.
}
\examples{
 
library("PlackettLuce")

R <- matrix(c(1, 2, 0, 0,
              4, 1, 2, 3,
              2, 4, 3, 1,
              1, 2, 3, 0,
              2, 1, 1, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")
R <- as.rankings(R)

PC <- rank_paircomp(R)

#############################################

# using breadwheat data
data("breadwheat", package = "gosset")

# convert the tricot rankings from breadwheat data
# into a object of class 'rankings' from PlackettLuce
R <- rank_tricot(breadwheat,
                 items = c("variety_a","variety_b","variety_c"),
                 input = c("overall_best","overall_worst"))


PC <- rank_paircomp(R)

}
\references{
Strobl C., Wickelmaier F. & Zeileis A. (2011). 
Journal of Educational and Behavioral Statistics, 36(2), 135–153.
doi:10.3102/1076998609359791
}
\seealso{
\code{\link[PlackettLuce]{rankings}}, 
\code{\link[psychotools]{paircomp}}

Other rank functions: 
\code{\link{rank_binomial}()},
\code{\link{rank_numeric}()},
\code{\link{rank_tricot}()}
}
\author{
Kauê de Sousa and Jacob van Etten
}
\concept{rank functions}
