% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_ws.R
\name{gs_ws_new}
\alias{gs_ws_new}
\title{Add a new worksheet within a spreadsheet}
\usage{
gs_ws_new(ss, ws_title = "Sheet1", row_extent = 1000, col_extent = 26,
  ..., verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws_title}{the title for the new, sole worksheet; if unspecified, the
Google Sheets default is "Sheet1"}

\item{row_extent}{integer for new row extent; if unspecified, the Google
Sheets default is 1000}

\item{col_extent}{integer for new column extent; if unspecified, the Google
Sheets default is 26}

\item{...}{optional arguments passed along to \code{\link{gs_edit_cells}} in
order to populate the new worksheet with data}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{\link{googlesheet}} object
}
\description{
Add a new worksheet to an existing spreadsheet. By default, it will [1] have
1000 rows and 26 columns, [2] contain no data, and [3] be titled "Sheet1".
Use the \code{ws_title}, \code{row_extent}, \code{col_extent}, and \code{...}
arguments to give the worksheet a different title or extent or to populate it
with some data. This function calls the
\href{https://developers.google.com/drive/v2/reference/}{Google Drive API} to
create the worksheet and edit its title or extent. If you provide data for
the sheet, then this function also calls the
\href{https://developers.google.com/google-apps/spreadsheets/}{Google Sheets
API}. The title of the new worksheet can not be the same as any existing
worksheet in the sheet.
}
\details{
We anticipate that \strong{if} the user wants to control the extent of the
new worksheet, it will be by providing input data and specifying `trim =
TRUE` (see \code{\link{gs_edit_cells}}) or by specifying \code{row_extent}
and \code{col_extent} directly. But not both ... although we won't stop you.
In that case, note that explicit worksheet sizing occurs before data
insertion. If data insertion triggers any worksheet resizing, that will
override any usage of \code{row_extent} or \code{col_extent}.
}
\examples{
\dontrun{
# get a copy of the Gapminder spreadsheet
gap_ss <- gs_copy(gs_gap(), to = "Gapminder_copy")
gap_ss <- gs_ws_new(gap_ss)
gap_ss <- gs_ws_delete(gap_ss, ws = "Sheet1")
gap_ss <-
  gs_ws_new(gap_ss, ws_title = "Atlantis", input = head(iris), trim = TRUE)
gap_ss
gs_delete(gap_ss)
}

}
