% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environments.R
\name{gtm_environments_create}
\alias{gtm_environments_create}
\title{Create an environment}
\usage{
gtm_environments_create(
  account_id,
  container_id,
  name,
  description = NULL,
  debug = c("TRUE", "FALSE"),
  url = NULL
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{name}{The environment display name. Can be set or changed only on USER type environments.}

\item{description}{The environment description. Can be set or changed only on USER type environments.}

\item{debug}{Whether or not to enable debug by default for the environment.}

\item{url}{Default preview page url for the environment.}
}
\description{
This creates a new GTM environment
}
\examples{
\dontrun{
accountId <- 1234567
containerId <- 7654321

env <- gtm_environments_create(accountId, containerId, "Development")

pp_env <- gtm_environments_create(accountId, 
                                  containerId, 
                                  "Pre-Prod", 
                                  debug=TRUE, 
                                  url="https://pp.example.com")
}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/environments/update}

Other environment functions: 
\code{\link{gtm_environments_delete}()},
\code{\link{gtm_environments_get}()},
\code{\link{gtm_environments_list}()},
\code{\link{gtm_environments_reauthorize}()},
\code{\link{gtm_environments_update}()}
}
\concept{environment functions}
