% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh_admin.R
\name{gce_ssh_addkeys}
\alias{gce_ssh_addkeys}
\title{Add SSH details to a gce_instance}
\usage{
gce_ssh_addkeys(instance, key.pub = NULL, key.private = NULL,
  username = Sys.info()[["user"]], overwrite = FALSE)
}
\arguments{
\item{instance}{The gce_instance}

\item{key.pub}{filepath to public SSH key}

\item{key.private}{filepath to the private SSK key}

\item{username}{SSH username to login with}

\item{overwrite}{Overwrite existing SSH details if they exist}
}
\value{
The instance with SSH details included in $ssh
}
\description{
Add SSH details to a gce_instance
}
\details{
You will only need to run this yourself if you save your SSH keys somewhere other 
  than \code{$HOME/.ssh/google_compute_engine.pub} or use a different username than 
  your local username as found in \code{Sys.info[["user"]]}, otherwise it will configure 
  itself automatically the first time you use \link{gce_ssh} in an R session.

If key.pub is NULL then will look for default Google credentials at 
  \code{file.path(Sys.getenv("HOME"), ".ssh", "google_compute_engine.pub")}
}
\examples{

\dontrun{
  
  library(googleComputeEngineR)
  
  vm <- gce_vm("my-instance")
  
  ## if you have already logged in via gcloud, the default keys will be used
  ## no need to run gce_ssh_addkeys
  ## run command on instance            
  gce_ssh(vm, "echo foo")
  
  
  ## if running on Windows, use the RStudio default SSH client
  ## e.g. add C:\\Program Files\\RStudio\\bin\\msys-ssh-1000-18 to your PATH
  ## then run: 
  vm2 <- gce_vm("my-instance2")

  ## add SSH info to the VM object
  ## custom info
  vm <- gce_ssh_setup(vm,
                      username = "mark", 
                      key.pub = "C://.ssh/id_rsa.pub",
                      key.private = "C://.ssh/id_rsa")
                      
  ## run command on instance            
  gce_ssh(vm, "echo foo")
  #> foo

  ## example to check logs of rstudio docker container
  gce_ssh(vm, "sudo journalctl -u rstudio")

}
}
\seealso{
Other ssh functions: \code{\link{gce_ssh_browser}},
  \code{\link{gce_ssh_setup}}, \code{\link{gce_ssh}}
}
\concept{ssh functions}
