% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml.R
\name{cr_build_yaml}
\alias{cr_build_yaml}
\title{Create a cloudbuild Yaml object in R}
\usage{
cr_build_yaml(
  steps,
  timeout = NULL,
  logsBucket = NULL,
  options = NULL,
  substitutions = NULL,
  tags = NULL,
  secrets = NULL,
  availableSecrets = NULL,
  images = NULL,
  artifacts = NULL,
  serviceAccount = NULL
)
}
\arguments{
\item{steps}{A vector of \link{cr_buildstep}}

\item{timeout}{How long the entire build will run. If not set will be 10mins}

\item{logsBucket}{Where logs are written.  If you don't set this field, Cloud Build will use a default bucket to store your build logs.}

\item{options}{A named list of options}

\item{substitutions}{Build macros that will replace entries in other elements}

\item{tags}{Tags for the build}

\item{secrets}{A secrets object}

\item{availableSecrets}{What environment arguments from Secret Manager are available to the build - create via \link{cr_build_yaml_secrets}}

\item{images}{What images will be build from this cloudbuild}

\item{artifacts}{What artifacts may be built from this cloudbuild - create via \link{cr_build_yaml_artifact}}

\item{serviceAccount}{What service account should the build be run under?}
}
\description{
This can be written to disk or used directly with functions such as \link{cr_build}
}
\examples{
cr_project_set("my-project")
image <- "gcr.io/my-project/my-image"
cr_build_yaml(
  steps = c(
    cr_buildstep("docker", c("build", "-t", image, ".")),
    cr_buildstep("docker", c("push", image)),
    cr_buildstep("gcloud", c("beta", "run", "deploy", "test1", "--image", image))
  ),
  images = image
)
}
\seealso{
\href{https://cloud.google.com/build/docs/build-config-file-schema}{Build configuration overview for cloudbuild.yaml}

Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
