% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers.R
\name{cr_buildtrigger_copy}
\alias{cr_buildtrigger_copy}
\title{Copy a buildtrigger}
\usage{
cr_buildtrigger_copy(
  buildtrigger,
  filename = NULL,
  name = NULL,
  tags = NULL,
  build = NULL,
  ignoredFiles = NULL,
  github = NULL,
  substitutions = NULL,
  includedFiles = NULL,
  disabled = NULL,
  triggerTemplate = NULL,
  projectId = cr_project_get()
)
}
\arguments{
\item{buildtrigger}{A \code{CloudBuildTriggerResponse} object from \link{cr_buildtrigger_get}}

\item{filename}{Path, from the source root, to a file whose contents is used for the build}

\item{name}{User assigned name of the trigger}

\item{tags}{Tags for annotation of a `BuildTrigger`}

\item{build}{Contents of the build template}

\item{ignoredFiles}{ignored_files and included_files are file glob matches extended with support for "**".}

\item{github}{a \link{GitHubEventsConfig} object - mutually exclusive with \code{triggerTemplate}}

\item{substitutions}{A named list of Build macro variables}

\item{includedFiles}{If any of the files altered in the commit pass the ignored_files}

\item{disabled}{If true, the trigger will never result in a build}

\item{triggerTemplate}{a \link{RepoSource} object - mutually exclusive with \code{github}}

\item{projectId}{The projectId you are copying to}
}
\description{
This lets you use the response from \link{cr_buildtrigger_get} for an existing buildtrigger to copy over settings to a new buildtrigger.
}
\details{
Overwrite settings for the build trigger you are copying by supplying it as one of the other arguments from \link{BuildTrigger}.
}
\examples{

\dontrun{
#copying a GitHub buildtrigger across projects and git repos
bt <- cr_buildtrigger_get("my-trigger", projectId = "my-project-1")

# a new GitHub project
gh <- GitHubEventsConfig("username/new-repo",
                         event = "push",
                         branch = "^master$")

# give 'Cloud Build Editor' role to your service auth key in new project
# then copy configuration across
cr_buildtrigger_copy(bt, github = gh, projectId = "my-new-project")


}
}
\seealso{
Other BuildTrigger functions: 
\code{\link{BuildTrigger}()},
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_repo}()},
\code{\link{cr_buildtrigger_run}()},
\code{\link{cr_buildtrigger}()}
}
\concept{BuildTrigger functions}
